// Copyright 2006-2007 Adobe Systems Incorporated.  All rights reserved.
//************** GLOBALS VARS *****************
var SPRY_XMLDATASET_IMG_FILENAME = "SpryXMLDataSet.gif";
var SPRY_XMLDATAFIELD_IMG_FILENAME = "DSL_D.gif";
//****************** API **********************

//--------------------------------------------------------------------
// FUNCTION:
//   addDynamicSource
//
// DESCRIPTION:
//   Adds a Dynamic Source to the Data Bindings panel
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------

function addDynamicSource()
{
	//launch the ajax data set
	var cmdArgs = new Array();

	//fix for bug 221267
	var bCanInsert = ajaxUtils.canInsertSpryDataSets();
	if (bCanInsert)
	{
		var resArray = dwscripts.callCommand("SpryXMLDataSet_Basic",cmdArgs);
	}
}


//--------------------------------------------------------------------
// FUNCTION:
//   findDynamicSources
//
// DESCRIPTION:
//   Returns a list of Dynamic Sources on the page
//
// ARGUMENTS:
//   none
//
// RETURNS:
//   JavaScript Array of Objects
//--------------------------------------------------------------------

function findDynamicSources()
{
	var retList = new Array();
	var dom = dw.getDocumentDOM();
	var ajaxDataSets = ajaxUtils.getAjaxDataSetNames(dom);
	if (ajaxDataSets != null)
	{
		//look for ajax data set(s) in this script block
		for (var i=0; i < ajaxDataSets.length ; i++)
		{
			retList.push(new DataSource(ajaxDataSets[i], 
								  SPRY_XMLDATASET_IMG_FILENAME, 
								  true, 
								  "SpryXMLDataSet.htm"))			
		}
	}
  return retList;
}


//--------------------------------------------------------------------
// FUNCTION:
//   generateDynamicSourceBindings
//
// DESCRIPTION:
//   Returns a list of bindings for the given elementName on the page.
//
// ARGUMENTS:
//   sourceName - string - the name returned from the findDynamicSources
//     function
//
// RETURNS:
//   JavaScript Array of Objects
//--------------------------------------------------------------------

function generateDynamicSourceBindings(sourceName)
{
	var retVal = new Array();
	var dom = dw.getDocumentDOM();
	var ajaxDataSets = ajaxUtils.getAjaxDataSets(dom,sourceName);
	if ((ajaxDataSets != null) && (ajaxDataSets.length > 0))
	{
		var anAjaxDataSet = ajaxDataSets[0];
		var schemaArray   = anAjaxDataSet.getSchemaArray();
		var spryBuiltInTokens = ["ds_RowID","ds_CurrentRowID","ds_RowCount"];

		for (var i=0; i < schemaArray.length; i++)
		{
			//add it to the binding arrays,add it to the list
			var aSchemaNode = schemaArray[i];
			//append the @ sign for attribute schema elements
			var schemaNodeName = aSchemaNode.getFullNodeName();
			var colType	= anAjaxDataSet.getColType(schemaNodeName);
			var aDSBinding = new DataSourceBinding(schemaNodeName,SPRY_XMLDATAFIELD_IMG_FILENAME,false,"SpryXMLDataSet.htm",schemaNodeName,colType);
			retVal.push(aDSBinding);
		}
		//add the builtin tokens
		if (schemaArray && schemaArray.length)
		{
			for (var i=0; i < spryBuiltInTokens.length; i++)
			{
				var aDSBinding = new DataSourceBinding(spryBuiltInTokens[i],SPRY_XMLDATAFIELD_IMG_FILENAME,false,"SpryXMLDataSet.htm",spryBuiltInTokens[i]);
				retVal.push(aDSBinding);
			}
		}
	}
	return retVal;
}


//--------------------------------------------------------------------
// FUNCTION:
//   generateDynamicDataRef
//
// DESCRIPTION:
//   Returns a dynamic binding string.
//
// ARGUMENTS:
//   sourceName - string - the name of the dynamic source returned
//     from the findDynamicSources function
//   bindingName - string - the name of a dynamic source binding returned
//     from generateDynamicSourceBindings
//
// RETURNS:
//   string - the code to insert on the page
//--------------------------------------------------------------------

function generateDynamicDataRef(sourceName, bindingName, dropObject, colType)
{
  var retStr = "";
  if ((sourceName.length) && (bindingName.length ==0))
  {
	if (dropObject != null)
	{
		var cmdArgs = new Array();
		cmdArgs.push(sourceName);
		cmdArgs.push(dropObject); //location where the drop is happening
		var resArray = dwscripts.callCommand("InsertSpryDataTable.htm",cmdArgs);
		if (resArray && resArray.length)
		{
			retStr = resArray;
		}
	}
	else
	{
		//a placeholder
		retStr = sourceName;
	}
  }
  else if ((bindingName != null) && (bindingName.length))
  {
		retStr = "{" + sourceName + "::" + bindingName + "}";	
		//only if we doing a d&d from bindings panel (floater mode) on design layout
		//provide the below <img src="{binding}"/> drop code
		if ((colType == "image") && (dropObject != null))
		{
			retStr = ajaxUtils.getSpryImageReference(retStr);
		}
  }
  return retStr;
}


//--------------------------------------------------------------------
// FUNCTION:
//   inspectDynamicDataRef
//
// DESCRIPTION:
//   Inspects a dynamic binding string and returns a pair of 
//   source and binding values.
//
// ARGUMENTS:
//   expression - string - the dynamic binding expression to be
//     inspected
//
// RETURNS:
//   JavaScript Array of strings - an array of length 2, with the first
//   value being the sourceName, and the second being the bindingName
//--------------------------------------------------------------------

function inspectDynamicDataRef(expression)
{
  var retArray = new Array();

  /*if(expression.length)
  {
    var params = extPart.findInString("Application_DataRef", expression);
    if (params)
    {
      retArray[0] = params.sourceName;
      retArray[1] = params.bindingName;
    }
  }*/
    
  return retArray;
}


//*-------------------------------------------------------------------
// FUNCTION:
//   editDynamicSource
//
// DESCRIPTION:
//   edits a dynamic source from the document.
//
// ARGUMENTS:
//   sourceName - a data source name
//   bindingName - one of the bindings for that data source
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------
function editDynamicSource(sourceName, bindingName)
{
	var dom = dw.getDocumentDOM();
	if ((sourceName.length) && (bindingName.length == 0))
	{
		var ajaxDataSets = ajaxUtils.getAjaxDataSets(dom,sourceName);
		if ((ajaxDataSets != null) && (ajaxDataSets.length > 0))
		{
			var anAjaxDataSet = ajaxDataSets[0];
			if (anAjaxDataSet)
			{
				//launch the command to re-edit
				var cmdArgs = new Array();
				//push the ajax data set
				cmdArgs.push(anAjaxDataSet);
				var resArray = dwscripts.callCommand("SpryXMLDataSet_Basic",cmdArgs);
			}
		}
	}
}



//--------------------------------------------------------------------
// FUNCTION:
//   deleteDynamicSource
//
// DESCRIPTION:
//   Deletes a dynamic source from the document.
//
// ARGUMENTS:
//   sourceName - string - the name of the dynamic source returned
//     from the findDynamicSources function
//   bindingName - string - the name of a dynamic source binding returned
//     from generateDynamicSourceBindings
//
// RETURNS:
//   nothing
//--------------------------------------------------------------------
function deleteDynamicSource(sourceName, bindingName)
{
	if ((sourceName.length) && (bindingName.length == 0))
	{
		//delete the ajax dataset
		//TODO : add the warning message 
		ajaxUtils.deleteAjaxDataSet(sourceName);
	}
}
